package ch.frankel.blog.lombok;

import static org.junit.Assert.assertEquals;

import java.util.ServiceLoader;

import lombok.javac.JavacAnnotationHandler;

import org.junit.Test;

/**
 * Test that checks that all handlers are taken into account.
 * 
 * @author Nicolas Frankel
 */
public class JavacAnnotationHandlersTest {

    /**
     * Tests whether the new Handler is accounted for.
     * 
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testCount() {

        ServiceLoader<JavacAnnotationHandler> loader = ServiceLoader.load(JavacAnnotationHandler.class);

        int count = 0;

        for (@SuppressWarnings("unused")
        JavacAnnotationHandler<?> handler : loader) {

            count++;
        }

        assertEquals(9 + 1, count);
    }
}
